##!/bin/bash

# Author: thaliondrambor
# Version: 0.0.2
# Description: shell script for controlling Yeelight Wifi devices from Xiaomi
#
#
# Changelog:
#	v0.0.3	- can choose effect (smooth/sudden) for commands
#			- added toggle command
#			- brightness of 0% switches off the device
#			- added color temperature
#			- added hue and saturation
#	v0.0.2	- cut of decimal places of dim variable (needed for slider in fhem)
#			- added description and instructions
#	v0.0.1	- 1. release (just for trying)
#
# Usage:
# run 'bash yeelight.sh [IP] [COMMAND] {EFFECT}'
# for [IP] insert IP-address of Yeelight device, e.g. 192.168.0.15
# for [COMMAND] you can insert:
#	COMMAND					DESCRIPTION											Example											ADDITIONAL COMMENTARY
#	on						turns device on										bash yeelight.sh 192.168.0.15 on
#	off						turns device off									bash yeelight.sh 192.168.0.15 off
#	toggle					toggles device state (on/off)						bash yeelight.sh 192.168.0.15 toggle			no effect possible
#	dim [X]					changes brightness to X% [0-100]					bash yeelight.sh 192.168.0.15 dim 30			if X misses or is out of range it will become 50
#																				bash yeelight.sh 192.168.0.15 dim 0				if X is 0 it turns the device off
#	rgb [X][Y][Z]			changes color to XYZ [0-255] in RGB-Code			bash yeelight.sh 192.168.0.15 rgb 100 0 220		if 1 or 2 of X Y Z are missing or is out of range it will become 0
#																				bash yeelight.sh 192.168.0.15 rgb				if all 3 are missing color will become white
#	ct [X]					changes color temperature [1700-6500]				bash yeelight.sh 192.168.0.15 ct				if X is missing or out of range it will become 6500
#	hsv [X][Y]				changes color with hue [0-359] and
#							saturation [0-100]									bash yeelight.sh 192.168.0.15 hsv 200 30		if X is missing our out of range it will become 359, Y will become 50
# for {EFFECT} you can insert:
#	[smooth|sudden] [T]		changes if the command is executed smooth or sudden	bash yeelight.sh 192.168.0.15 on sudden			command is executed immediately, no time is needed
#																				bash yeelight.sh 192.168.0.15 off smooth 200	command fades in/out with the duration in milliseconds
#																				bash yeelight.sh 192.168.0.15 RGB 100 0 220		with no choosen effect, command is executed with a smooth effect with the duration of 500ms
#
# For questioning or reporting a bug please post at the fhem forum at https://forum.fhem.de/index.php/topic,59776.0/all.html

IP=$1
SET=$2
EFFECT="smooth"
EFFECTTIME=500

# Change power state
#	You can change the power state of the device with on, off and toggle
if [ "$SET" == "on" ] || [ "$SET" == "off"  ]
	then
	METHOD="set_power"
	if [ "$3" == "smooth" ] || [ "$3" == "sudden" ]
		then
		unset EFFECT
		EFFECT=$3
		if [ $4 ]
			then
			unset EFFECTTIME
			EFFECTTIME=$(echo "$4" | sed -r -e 's/(.*)\.[0-9]*/\1/')
		fi
	fi
	PARAMS='"'${SET}'","'${EFFECT}'",'${EFFECTTIME}
elif [ "$SET" == "toggle" ]
	then
	METHOD=$SET
	PARAMS=''
	
# Change the brightness of the device
elif [ "$SET" == "dim" ]
	then
	DIM=$(echo "$3" | sed -r -e 's/(.*)\.[0-9]*/\1/')
    if [ -z "$DIM" ] || [ ${DIM} -gt 100 ] || [ ${DIM} -lt 0 ]
		then
		DIM=50
    fi
	if [ "$4" == "smooth" ] || [ "$4" == "sudden" ]
		then
		unset EFFECT
		EFFECT=$4
		if [ $5 ]
			then
			unset EFFECTTIME
			EFFECTTIME=$(echo "$5" | sed -r -e 's/(.*)\.[0-9]*/\1/')
		fi
	fi
	if [ "$DIM" == 0 ]
		then
		METHOD="set_power"
		PARAMS='"off","'${EFFECT}'",'${EFFECTTIME}
	else
		METHOD="set_bright"
		PARAMS=${DIM}',"'${EFFECT}'",'${EFFECTTIME}
	fi
	
# Change Color
#	You can choose color with RGB-Mode, by color temperature and with hue and saturation
elif [ "$SET" == "RGB" ]
    then
	RED=$(echo "$3" | sed -r -e 's/(.*)\.[0-9]*/\1/')
    if [ -z "$RED" ] || [ ${RED} -gt 255 ] || [ ${RED} -lt 0 ]
		then
		unset RED
		RED=0
	fi
	GREEN=$(echo "$4" | sed -r -e 's/(.*)\.[0-9]*/\1/')
    if [ -z "$GREEN" ] || [ ${GREEN} -gt 255 ] || [ ${GREEN} -lt 0 ]
		then
		unset GREEN
		GREEN=0
	fi
	BLUE=$(echo "$5" | sed -r -e 's/(.*)\.[0-9]*/\1/')
    if [ -z "$BLUE" ] || [ ${BLUE} -gt 255 ] || [ ${BLUE} -lt 0 ]
		then
		unset BLUE
		BLUE=0
	fi
	COLOR=$[${RED} * 65536 + ${GREEN} * 256 + $BLUE]
	if [ "$COLOR" == 0 ]
		then
		COLOR=65793
	fi
	if [ "$6" == "smooth" ] || [ "$6" == "sudden" ]
		then
		unset EFFECT
		EFFECT=$6
		if [ $7 ]
			then
			unset EFFECTTIME
			EFFECTTIME=$(echo "$7" | sed -r -e 's/(.*)\.[0-9]*/\1/')
		fi
	fi
	METHOD="set_rgb"
	PARAMS=${COLOR}',"'${EFFECT}'",'${EFFECTTIME}
elif [ "$SET" == "ct" ]
	then
	CT=$(echo "$3" | sed -r -e 's/(.*)\.[0-9]*/\1/')
	if [ -z "$CT" ] || [ ${CT} -lt 1700 ] || [ ${CT} -gt 6500 ]
		then
		unset CT
		CT=6500
	fi
	if [ "$4" == "smooth" ] || [ "$4" == "sudden" ]
		then
		unset EFFECT
		EFFECT=$4
		if [ $5 ]
			then
			unset EFFECTTIME
			EFFECTTIME=$(echo "$5" | sed -r -e 's/(.*)\.[0-9]*/\1/')
		fi
	fi
	METHOD="set_ct_abx"
	PARAMS=${CT}',"'${EFFECT}'",'${EFFECTTIME}
elif [ "$SET" == "hsv" ]
	then
	HUE=$(echo "$3" | sed -r -e 's/(.*)\.[0-9]*/\1/')
	if [ -n "$HUE" ] && [ ${HUE} -ge 0 ] && [  ${HUE} -le 359 ]
		then
		SAT=$(echo "$4" | sed -r -e 's/(.*)\.[0-9]*/\1/')
		if [ -z "$SAT" ] || [ ${SAT} -lt 0 ] || [ ${SAT} -gt 100 ]
			then
			unset SAT
			SAT=50
		fi
	else
		unset HUE
		HUE=359
		SAT=50
	fi
	METHOD="set_hsv"
	PARAMS=${HUE}','${SAT}',"'${EFFECT}'",'${EFFECTTIME}
fi
if [ $METHOD ]
	then
	CMD=' { "id":1, "method":"'${METHOD}'", "params":['${PARAMS}']}\r\n'
	echo ${CMD}
	echo -ne ${CMD} | nc -w1 ${IP} 55443
else
	echo "Not allowed parameters given."
fi