# WS ioB in (inject) - Dynamic State Subscription

Subscribe to ioBroker state changes with dynamic control via input messages. This node extends the standard `iob-in` functionality by allowing you to change subscriptions at runtime and trigger immediate value updates.

## Key Features

- **Dynamic Subscription**: Change the monitored state(s) or pattern at runtime via `msg.topic`.
- **Trigger on Inject**: Force an immediate update of current values by sending an input message.
- **Array Support**: Subscribe to multiple states dynamically by passing an array of state IDs.
- **Environment Variables**: Full support for `${VAR_NAME}` substitution in dynamic topics.

## Input Configuration

The node accepts input messages to control its behavior:

### 1. Change Subscription (Single State)
Send a string in `msg.topic` to switch subscription to a new state ID or wildcard pattern.
```javascript
msg.topic = "0_userdata.0.temperature";
return msg;
```
*Effect*: Unsubscribes from previous state, subscribes to new state, and immediately sends the current value.

### 2. Change Subscription (Multiple States)
Send an array of strings in `msg.topic` to subscribe to multiple states simultaneously.
```javascript
msg.topic = [
    "0_userdata.0.temperature",
    "0_userdata.0.humidity",
    "${MY_ENV_VAR_STATE}"
];
return msg;
```
*Effect*: Unsubscribes from previous states, subscribes to all new states, and immediately sends current values for all of them.

### 3. Trigger Current Values
Send a message with **no topic** (or same topic) to force a re-read of current values.
```javascript
msg.payload = "trigger";
// msg.topic is undefined
return msg;
```
*Effect*: Immediately re-reads and sends the current value(s) of the currently subscribed state(s).

## Configuration Options

### Data Source
- **Initial State / Pattern**: (Optional) The state to subscribe to on startup. Can be overridden by input messages.
- **Server**: The ioBroker server connection.

### Filtering
- **Trigger on**: Filter by Acknowledged (ack=true) or Unacknowledged (ack=false) states.
- **Filter Mode**:
    - **Send all events**: No filtering.
    - **Send only value changes**: Ignores metadata updates.
    - **Send only value changes (with baseline)**: Pre-loads baseline to ensure clean change detection.
- **Send initial value on startup**: If enabled, sends current values immediately upon connection.
    - *Note*: Input messages **always** trigger an initial value send, regardless of this setting.

## Output Format

The output format matches the standard `iob-in` node:

### Single State / Wildcard
```javascript
{
  topic: "0_userdata.0.temperature",
  payload: 23.5,
  state: { val: 23.5, ack: true, ts: 1640995200000, ... },
  timestamp: 1640995200000,
  initial: true // Present if triggered by input or startup
}
```

### Multiple States
Always outputs individual messages for each state change (Grouped output mode is not currently supported for dynamic injection).

## Use Cases

### Dynamic Dashboard
Create a single dashboard widget that can display different metrics based on user selection.
1. User clicks "Temperature" button -> Inject `msg.topic = "sensors.temp"`.
2. User clicks "Humidity" button -> Inject `msg.topic = "sensors.hum"`.
3. The same `iob-in-inject` node updates the dashboard widget.

### Context-Aware Automation
Monitor different sensors based on time of day or system mode.
- **Day Mode**: Subscribe to `sensors.outdoor.light`.
- **Night Mode**: Subscribe to `sensors.indoor.motion`.

### Bulk Data Fetching
Trigger a read of multiple states on demand (e.g., for a report) without keeping permanent subscriptions open (by switching to a dummy state afterwards, or just using the trigger feature).
